
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Dec 14 15:04:40 2004
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief DES external application ATP tests  
   *
   *  \version CRYS_Ext_ATP_DES_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/***** Include Files ******/
#include "CRYS.h"
 
#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_DES_Acceptance.h"
#include "CRYS_Ext_ATP_DES_Acceptance_test_vectors.h"
#include "CRYS_HOST_TST_DES.h"

#include "DX_VOS_Mem.h"
#include <stdio.h>


/******** Defines ********/ 
/******** Enums **********/ 
/********* Typedefs ********/ 
/******** Global Data ********/ 
static CRYS_DES_EncryptMode_t TST_EncryptMode[] = { CRYS_DES_Encrypt , CRYS_DES_Decrypt };

extern char FailureFunctionNameOut[FailureFunctionName_K_Size];
static char* encryptModeStr[] = {"Encrypt mode", "Decrypt mode"};
/***** Private function prototype ******/ 
/******** Public Functions *****/ 
CRYSError_t SEPQA_ATP_CheckErrorReturn(CRYSError_t  TST_ErrorRet,
									   char         TST_FuncName[TST_FUNC_STRING_LEN],
									   char        *FailureFunctionNameOut_ptr,        
									   DxUint32_t   FuncNameMaxSize);

/******** Private Functions ******/ 
/***************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_DES_Acceptance_NON_integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for AES non integrated function,
 *  implemented as external SEP application                          .
 *  DES modes                   - CBC/ECB
 *  Vector sizes used (in bytes) - 16/32/512                                 
 *  Key Size used (in bits)     - 128/192/256                               
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the SEPQA_DES_NotIntegrated function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_ExtApp_ATP_DES_NON_integrated ( void ) 
{
    /*** TST Variables Definitions ****/
    int                     TST_index=0;
	CRYSError_t             TST_TestStatus=0;
    int                     TST_OuputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_DES_Acceptance_NON_integrated"; 
    
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ExtApp_ATP_DES_Acceptance_NON_integrated Tests ******* \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n\n"));

    /****************************/
    /***** Start of test ********/
    /****************************/
    for (TST_OuputLocation =0 ; TST_OuputLocation < 2 ;TST_OuputLocation++) 
    {
        for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++)     /*Select mode or operation  
                                                                                                          TST_OperationMode = 0 == Encrypt
                                                                                                          TST_OperationMode = 1 == Decrypt*/
		{           
                                                            
            if (TST_OuputLocation == 0) /*Select output buffer*/
            {   
                /* output buffer != input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n")); 
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s [test 1A.%d] \n",SEP_DES_Acceptance_TestData[TST_index].TST_Name,TST_index ));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   output buffer != input buffer                                       \n"));         
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s              \n", encryptModeStr[TST_ATP_EncryptDecryptFlag]));         
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n")); 
            }
            else
            {
                /* output buffer == input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n")); 
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s [test 1B.%d] \n",SEP_DES_Acceptance_TestData[TST_index].TST_Name,TST_index));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   output buffer == input buffer (output buffer)                       \n"));                             
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s              \n", encryptModeStr[TST_ATP_EncryptDecryptFlag]));         
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n")); 
            }
            
			/* calling the DES ATP SEP function */ 
			/*----------------------------------*/
			TST_ATP_Error = SEPQA_DES_NotIntegrated(
									SEP_DES_Acceptance_TestData[TST_index].TST_IvCounter,
									&SEP_DES_Acceptance_TestData[TST_index].TST_Key,
									SEP_DES_Acceptance_TestData[TST_index].TST_NumOfKeys,
									TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
									SEP_DES_Acceptance_TestData[TST_index].TST_OperationMode,
									SEP_DES_Acceptance_TestData[TST_index].TST_input_data, 
									SEP_DES_Acceptance_TestData[TST_index].TST_dataSize, 
									SEP_DES_Acceptance_TestData[TST_index].TST_Expected_output_data,
									SEP_DES_Acceptance_TestData[TST_index].TST_dataSize,
									TST_OuputLocation,
									FailureFunctionNameOut,
									FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_DES_NotIntegrated",FailureFunctionNameOut,TST_MasterTestName);                   

#if CRYS_ATP_TST_EXIT_ON_ERROR
			if (TST_TestStatus != TESTPASS) 
				return TESTFAIL;
#endif  	
						
					
                
		}/* End of TST_ATP_EncryptDecryptFlag*/ 
    } /* End of TST_OuputLocation loop*/
  return TST_TestStatus; 
}/* End of CRYS_ATP_TST_DES_Acceptance_NON_integrated*/ 




/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_ExtApp_ATP_DES_Acceptance_Integrated      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for DES integrated API                           
 *  This function Encrypts and Decrypts known vectors using DES
 *  DES modes                   - CBC/ECB
 *  Vector sizes used (in bytes) - 16/32/512/1536           
 *  Key Size used (in bits)     - 128/192/256                               
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the CRYS_DES function to use the DES encryption/decryption process
 * 2. Compare the outputted result to the expected one                                                   
 *
 **************************/    
CRYSError_t CRYS_ExtApp_ATP_DES_Integrated ( void ) 
{

    /*** TST Variables Definitions ****/
    int         TST_index = 0;
	CRYSError_t TST_TestStatus=0;
    int         TST_OuputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_DES_Acceptance_Integrated";     
    
    /*** TST Variables initialization ***/
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," *********************** \n")); 
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ** CRYS_ExtApp_ATP_DES_Acceptance_Integrated Tests     ******* \n"));     
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," *********************** \n \n"));

    
    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_OuputLocation =0 ; TST_OuputLocation < 2 ;TST_OuputLocation++) 
    {
        for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++) /*Select mode or operation  
                                                                                                      TST_OperationMode = 0 == Encrypt
                                                                                                      TST_OperationMode = 1 == Decrypt*/
		{
            if (TST_OuputLocation == 0)/*Select output buffer*/ 
            {   
                /* output buffer != input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2A.%d]  **\n",SEP_DES_Acceptance_TestData[TST_index].TST_Name,TST_index));   
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer != input buffer                                       \n"));                    
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s              \n", encryptModeStr[TST_ATP_EncryptDecryptFlag]));         
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            }
            else
            {
                /* output buffer == input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2B.%d]   **\n",SEP_DES_Acceptance_TestData[TST_index].TST_Name,TST_index));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer == input buffer (output buffer)                         \n"));                      
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"   %s              \n", encryptModeStr[TST_ATP_EncryptDecryptFlag]));         
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            }

			/* calling the DES ATP SEP function */ 
			/*----------------------------------*/
			TST_ATP_Error = SEPQA_DES_Integrated(
				SEP_DES_Acceptance_TestData[TST_index].TST_IvCounter,
				&SEP_DES_Acceptance_TestData[TST_index].TST_Key,
				SEP_DES_Acceptance_TestData[TST_index].TST_NumOfKeys,
				TST_EncryptMode[TST_ATP_EncryptDecryptFlag],
				SEP_DES_Acceptance_TestData[TST_index].TST_OperationMode,
				SEP_DES_Acceptance_TestData[TST_index].TST_input_data, 
				SEP_DES_Acceptance_TestData[TST_index].TST_dataSize, 
				SEP_DES_Acceptance_TestData[TST_index].TST_Expected_output_data,
				SEP_DES_Acceptance_TestData[TST_index].TST_dataSize,
				TST_OuputLocation,
				FailureFunctionNameOut,
				FailureFunctionName_K_Size);
				
			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_DES_Integrated",FailureFunctionNameOut,TST_MasterTestName);                   

#if CRYS_ATP_TST_EXIT_ON_ERROR
			if (TST_TestStatus != TESTPASS) 
				return TESTFAIL;
#endif  		            
        }/* End of TST_ATP_EncryptDecryptFlag*/ 
        
    } /* End of TST_OuputLocation loop*/
  return TST_TestStatus;
}/* End of CRYS_ATP_TST_DES_Acceptance_Integrated */
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/


